**** PortStatus.s ********************************************************
* TITLE 	: portstat
* Author	: Richard Steventon
* Description	: ( %1 or %2 --> $ "x" ) where "x" is one of:
*		  " "   : no card
*		  "F"   : free/RAM
*		  "R"   : ROM/write-protected
*		  "M"   : MERGE'd
* History	: 10 April 1995 (done on Jazz... no optimization done)
**************************************************************************
ASSEMBLE
** Unsupported entry points 
CONFTAB 	EQU	#70428			* sx, no longer supported
CARD1STAT	EQU	#8052F			* gx status nib for slot 1
CARD2STAT	EQU	#80531			* gx status nib for slot 2
** ST status flags
GX		EQU	0
RPL
::
CK1NoBlame DUPTYPEREAL? NcaseTYPEERR	( Need 1 Arg, real )
COERCE $ " " TOTEMPOB SWAP
CODE
**  ( # --> $ )
	GOSBVL	=POP#			pop hxs
	GOSBVL	=SAVPTR 		save regs
* Registers saved, # in A.A
	?A=0	P			is it zero ?
	GOYES	error			then Bad Argument Value Error
	LC(1)	2
	?A<=C	P			less than or equal to 2 ?
	GOYES	ok!			no? then error
error	LA(5)	=argvalerr
	GOVLNG	=Errjmp
ok!
* Check if we are on an SX or GX
	CLRST				clear ST register
	D0=(5)	=IRAM@
	A=DAT0	S
	A=A+A	S			CS = G/GX
	GONC	sx
	ST=1	GX			set GX !
sx	LC(1)	1
	?C=A	P			port 1 ?
	GOYES	Port1			no, do port 2
* port 2 here
	?ST=0	GX
	GOYES	sx2
	D0=(5)	=CARD2STAT		GX : port 2
	GOTO	Ports
sx2	D0=(5)	(=CONFTAB)+15		SX : port 2
	GOTO	Ports
Port1
	?ST=0	GX
	GOYES	sx1
	D0=(5)	=CARD1STAT		GX : port 1
	GOTO	Ports
sx1	D0=(5)	(=CONFTAB)+4		SX : port 1
* Now D0 is address of port nib we want
Ports	A=DAT0	B			get 2 nibs data
	LC(2)	#0E			mask
	A=A&C	B			AND data with mask
	?A=0	B			zero ? then no card, so exit
	GOYES	exit!
	GOSUB	pTable
	NIBHEX	80			mask
	CON(2)	82			R=ROM
	NIBHEX	C0
	CON(2)	70			F=Free/RAM
	NIBHEX	E0
	CON(2)	77			M=Merge'd
pTable	C=RSTK
	D0=C				D0 = addr opf jump table
lp	C=DAT0	B			get compare value
	?C=A	B			same ?
	GOYES	Found!
	D0=D0+	4			go try next value
	GOTO	lp
Found!	D0=D0+	2			point to char data
	C=DAT1	A			get address of string
	D1=C
	D1=D1+	10			point to string data
	C=DAT0	B			read char
	DAT1=C	B			write char
exit!	GOVLNG	=GETPTRLOOP		restore regs and exit
ENDCODE
;
********************************************************************
