* S\->N -- Converts SPICE-scaled value string into
*          a real number
* Version 1.0 1993/10/15
* (C) Copyright 1993 by James Unterburger.
* All rights reserved.
*
* Converts SPICE-scaled value strings into real numbers
* INPUT:
* 1:  string of SPICE-scaled number, e.g., "-1.234MEG",
*     OR
*     real number (which is just passed through as-is
*     with no processing)
*
* OUTPUT:
* 1:  real number representation of value,
*     e.g., -1.234E6
*
* This string-to-real-number converter recognizes
* the following SPICE scale factors:
*
*     F   = 1E-15
*     P   = 1E-12
*     N   = 1E-09
*     U   = 1E-06
*     M   = 1E-03
*     K   = 1E+03
*     MEG = 1E+06      (same as 'ME', just like SPICE)
*     G   = 1E+09
*     T   = 1E+12
*
* Note that the SPICE2G.6-supported token
*     MIL = 2.54E-02
* is NOT SUPPORTED.
*
* This routine uses the first 15 significant digits
* of the manitissa when constructing its output number
* which is rounded to 12-digits, a standard HP48SX 
* real number.  Numbers with more than 15 digits can
* be used as input, but only the first 15 significant 
* digits will be used (and then rounded to 12 digits).
*
* This routine is case-insensitive.
*
* Scientific notation is legal and will produce
* expected results.
* Only the first 3 digits of the exponent will be used,
* and they should not exceed the maximum of 499;
* else an Overflow condition will exist.  Exponents
* less than -499 will the cause corresponding Positive
* or Negative Underflow condition to exist.  Both
* Overflow and Underflow conditions are handled according 
* to the system flags for Math exceptions; see the 
* user's manual for details about which flags these are.
*
* ######## THIS ROUTINE ALWAYS RETURNS A VALUE #########
*
* This routine differs from SPICE in several
* unimportant ways which relate to the handling of
* non-standard characters in the input string.  This
* routine will return the value of as much of the input
* string as can be parsed as a number, returning zero for
* non-parseable numbers, whereas SPICE will sometimes
* generate an error for non-parseable numbers.
* Furthermore, this routine ignores all leading
* non-numeric characters whose ASCII code less is than
* or equal to 2Ch, the comma character ","), whereas
* SPICE will treat leading commas differently.  Since
* leading plus characters ("+") are ignored, numbers
* with 2 or more leading "+" characters (which cause an
* error in SPICE?) will parse OK in this routine.
* Stick to generally recognizable numbers and you
* will be OK.
*
* Mixing scientific notation and SPICE-scale
* factors has the same affect as in SPICE,
* i.e., the scale factor is ignored.
*
* Examples:
*     "12345.t"                ==> 1.2345E16
*     "1.2345e-034"            ==> 1.2345E-34
*     "-1.234E+0234"           ==> -1.234E23
*     "(,++-.0023x8"           ==> -2.3E-3 
*     "-12345678901234567890K" ==> -1.23456789012E22
*     "-123.4e2K"              ==> -1.234E4
*     "  BEAVIS "              ==> 0
*
* This routine was tested on a HP48SX-E machine, but
* since it uses only supported entry points and 
* involves no graphics and other fancy doings, 
* it is anticipated that it will work fine on 
* the HP48G/X series.
*
* Finally, I wrote and rewrote this routine trying
* to minimize the size, so there are certain
* inefficiencies in the processing as far as speed goes.
* So don't flame me for these; rather, praise me for 
* how compact and robust the code is!
*
TITLE Unformat SPICE-scaled number
ASSEMBLE
   NIBASC  /HPHP48-E/
RPL
::
  CK1NoBlame
  CK&DISPATCH1
  THREE
ASSEMBLE
negmant    EQU #0               negative mantissa flag
inmant     EQU #1               parsing mantissa? flag
non0fnd    EQU #2               found a non-zero digit?
decptfnd   EQU #3               found decimal point?
fieldfull  EQU #4               have we filled field?
parseE     EQU #5               prev. char. was an "E"
negexp     EQU #6               negative exponent flag
inexp      EQU #7               parsing stuff after "E"?
*
sigdigs    EQU 15               how many mantissa digits
expsigdigs EQU 3                how many exponent digits
RPL
  CODE
        D1=D1+  5               pop stack of one
        D=D+1   A               item (string)
        GOSBVL  =SAVPTR         save pointers
        D1=D1-  5               restore stack item 
        A=0     W               
        R0=A
        R1=A
        R2=A                    zero R0, R1, and R2
*                               R0(A) = parsed exponent
*                               R0(S) = sign of mantissa
*                               R1(14:0) = parsed mant.
*                               R2(A) = adjstment to exp
*
        LC(1)   (sigdigs)-1     # digits in mantissa
        CSRC                    move to C(S)
        GOSBVL  =GetStrLenStk   D1->1st char., C(A)=leng
        D=C     A               D(A) = length (bytes)
        CLRST                   clear flags 0-11

STRIP   GOSUB   NXTCHR          A(B) = next char.
        LCASC   '-'             ignore all chars < '-'
        ?C>A    B
        GOYES   STRIP
        D1=D1-  2               adjust for LOOPTP
        D=D+1   A

LOOPTP  GOSUB   NXTCHR          A(B)=next char
        GOC     NOTDIG          carry set if not digit
        ?ST=1   inexp           exp digit? 
        GOYES   EXPDIG          goto exp.dig. handler
        ST=1    inmant          in mantissa
*
        SETDEC                  adjust exponent:
        CR2EX                   
        ?ST=0   non0fnd         non0fnd:  +1
        GOYES   D1
        C=C+1   A
D1      ?ST=0   decptfnd        decptfnd: -1
        GOYES   D2
        C=C-1   A
D2      CR2EX                   back into R2
        SETHEX
*
        ?ST=1   fieldfull       are we full?
        GOYES   LOOPTP          yes, don't save digit
        LCHEX   0               
        ?A=C    P               is A(B) == '0'?
        GOYES   D3              yes, skip flag setting
        ST=1    non0fnd         no, set non0fnd
D3      ?ST=0   non0fnd         non-0 not found yet?
        GOYES   LOOPTP          yes, don't save digit
        P=C     15              P=loop counter
SHLP    P=P-1
        GOC     SHDONE          exit when done
        ASL     W               shift digit
        GONC    SHLP            loop BET
SHDONE  P=C     15              P=digit place
        CR1EX                   get mant in C(W)
        C=A     P               put digit into mant
        CR1EX                   mant back into R1
DECDS   C=C-1   S               decr. sigdigs counter
looptp  GONC    LOOPTP          not done yet, looptp
        ?ST=1   inexp           if inexp, DONE
        GOYES   done
        ST=1    fieldfull       set fieldfull
        GONC    LOOPTP          and looptp, BET

EXPDIG  ST=0    parseE          clear parseE
        CR0EX                   get exp into C(X)
        CSL     A               shift previous digit
        C=A     P               put new dig. in C(0)
        CR0EX
        GOC     DECDS           decr. sigdig, loop; BET

NOTDIG  ?ST=1   inexp           parsing exp?
        GOYES   ND1             yes, skip 
        LCASC   'P'             'P'=50h
        ?C=A    B
        GOYES   FNDP
        LCHEX   5               'U'=55h
        ?C=A    B
        GOYES   FNDU
        C=C-1   A               'T'=54h
        ?C=A    B
        GOYES   FNDT
        LCASC   'E'             'E'=45h
        ?C=A    B
        GOYES   FNDE
        C=C+1   A               'F'=46h
        ?C=A    B
        GOYES   FNDF
        C=C+1   A               'G'=47h
        ?C=A    B
        GOYES   FNDG
        LCHEX   B               'K'=4Bh
        ?C=A    B
        GOYES   FNDK
        LCHEX   E               'N'=4Eh
        ?C=A    B
        GOYES   FNDN
        C=C-1   A               'M'=4Dh
        ?C#A    B
        GOYES   NOTM            skip if not 'M'
        ?D=0    A               end of string?
        GOYES   FNDM            yes, it's 'M'
        GOSUB   NXTCHR          get next char.
        LCASC   'E'
        ?C=A    B               is it an 'E'? 
        GOYES   FNDMEG          yes, found 'MEG'
        GONC    FNDM            no, just 'M'; BET

done    GOTO    DONE            intermediate jump 

NOTM    LCASC   '.'             check for decpt
        ?A=C    B
        GOYES   FNDDOT

ND1     LCASC   '+'             '+'=2Bh
        ?A#C    B               
        GOYES   ND3             go check for '-'
*                               found '+'
        ?ST=0   parseE          '+' valid immediately
        GOYES   done            after 'E' only
        GONC    J1              BET

FNDF    P=P+1                   'F' ==> P=4
FNDP    P=P+1                   'P' ==> P=3
FNDN    P=P+1                   'N' ==> P=2
FNDU    P=P+1                   'U' ==> P=1
FNDM    ST=1    negexp          'M' ==> P=0
FNDK    GOTO    POPPER          'K' ==> P=0

FNDT    P=P+1                   'T' ==> P=3
FNDG    P=P+1                   'G' ==> P=2
FNDMEG  P=P+1                   'ME' ==> P=1
        GONC    POPPER          BET

FNDE    ST=1    parseE          set parseE flag
        ST=1    inexp           set inexp flag
        P=      (expsigdigs)-1  P=# exp.digs. to parse
        C=P     15              P into C(S) 
        GOC     lptp1           and looptp

ND3     LCHEX   D               '-'=2Dh
        ?A#C    B
        GOYES   DONE            if not '-' then done
*                               found '-'
        ?ST=0   inexp           not in exp?
        GOYES   J3              yes, skip
        ?ST=0   parseE          not just found 'E'?
        GOYES   DONE            yes, done
        ST=0    parseE          clear parseE
        ST=1    negexp          set negexp
lptp1   GOTO    LOOPTP          goto loop top
J3      ?ST=1   inmant          are we already in mant?
        GOYES   DONE            yes, done
        ST=1    negmant         set negmant
        ST=1    inmant          set inmant
        GONC    lptp1           BET

FNDDOT  ?ST=1   decptfnd        is this second decpt?
        GOYES   DONE            yes, done
        ST=1    inmant          set inmant
J1      ST=0    parseE          clr parseE (can't hurt)
        ST=1    decptfnd        set decptfnd
        GONC    lptp1           BET

NIBS    NIBHEX  3060902151      data for exp values
POPPER  C=PC                    get PC into C(A)
        C=C-CON A,((*)-(NIBS)+2) adjust back 
        C+P+1
        C+P+1                   add 2*P+2 to C(A)
        D1=C                    put data address into D1
        A=0     A               zero exponent 
        A=DAT1  B               get exp from data
        R0=A                    R0(A)=exponent 

DONE    SETDEC
        C=R2                    get exp adjustment
        A=R0                    get exponent, sign
        ?ST=0   negexp          non-neg exp?
        GOYES   J4              yes, skip
        A=-A    A               negate exp.
J4      A=A+C   A               final exp in A(A)
        ?ST=0   negmant         non-neg mant?
        GOYES   J5              yes, skip
        A=-A-1  S               put 9 in A(S)
J5      C=R1                    put mantissa 
        B=C     W               into B(14:0)
        GOSBVL  =PACK           pack AB into A
        GOVLNG  =PUSH%LOOP      push real, RPL Loop

NXTCHR  P=      0
        ?D=0    A               no more chars?
        GOYES   DONE            yes, done
        A=DAT1  B               get next char.
        LCASC   'za'            convert to upper case
        GOSUB   RANGE           is it in a-z range?
        GOC     UCASE           Carry set if not
        LC(2)   #20
        A=A-C   A               convert to upper case
UCASE   D1=D1+  2               increment pointer
        D=D-1   A               decr. string length
DRANGE  LCASC   '90'            check if digit
RANGE   ?C>A    B               (Carry clear if in range)
        RTNYES
        CSR     A
        CSR     A
        C=C-A   B
        RTN
  ENDCODE
  ONE                           ( REAL number )
  NOP                           ( do NOTHING, just pass it )
;
*
*     (C) Copyright 1993 by James Unterburger.
*     All rights reserved.
*
*     Noncommercial distribution allowed, provided that
*     this copyright message is preserved, and any
*     modified versions are clearly marked as such.
*
*     This routine may not be used in any commercial 
*     product without my permission.  "Shareware" and
*     "Giftware" are both included in this restriction.
*
*     This program makes use of undocumented low-level
*     features of the HP48SX calculator, and may or may
*     not cause loss of data, excessive battery drainage,
*     and/or damage to the calculator hardware.
*     The Author takes no responsibility whatsoever for
*     any damage caused by the use of or inability to use
*     this program.
*
*     THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
*     EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*     LIMITED TO, THE IMPLIED WARRANTIES OF
*     MERCHANTABILITY AND FITNESS FOR A PARTICULAR
*     PURPOSE.
*
* Please send comments, bug reports and suggestions
* to me:
*=======================================================
* James Unterburger         e-mail: jamesu@anacad.fr
* Tempologis Flat 215
* 2-bis Chemin des Preles
* 38240 Meylan FRANCE
*=======================================================
